/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.model;

import com.aptana.editor.php.core.model.IModelElement;
import com.aptana.editor.php.core.model.IModelElementDelta;
import com.aptana.editor.php.core.model.ISourceModel;
import com.aptana.editor.php.core.model.ISourceModule;
import com.aptana.editor.php.indexer.IModuleIndexListener;
import com.aptana.editor.php.indexer.PHPGlobalIndexer;
import com.aptana.editor.php.internal.core.builder.IDirectory;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.model.IModelDeltaListener;
import com.aptana.editor.php.internal.model.ISourceFolder;
import com.aptana.editor.php.internal.model.ModelElementDelta;
import com.aptana.editor.php.internal.model.impl.ModelElementDeltaBuilder;
import com.aptana.editor.php.internal.model.impl.SourceModel;
import com.aptana.editor.php.internal.model.utils.ModelUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModelManager {
    private static ModelManager instance = new ModelManager();
    private IModuleIndexListener moduleIndexListener;
    private ISourceModel model = new SourceModel();
    private Set<IModelDeltaListener> listeners = new HashSet<IModelDeltaListener>();

    public static ModelManager getInstance() {
        return instance;
    }

    public ISourceModel getModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IModelDeltaListener listener) {
        Set<IModelDeltaListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IModelDeltaListener listener) {
        Set<IModelDeltaListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    private ModelManager() {
        this.bindListeners();
    }

    private void bindListeners() {
        this.moduleIndexListener = new IModuleIndexListener(){
            private Map<ISourceModule, ModelElementDeltaBuilder> deltaBuilders = new HashMap<ISourceModule, ModelElementDeltaBuilder>();

            @Override
            public void afterIndexChange(List<IModule> added, List<IModule> changed, List<IDirectory> addedDirectories) {
                ModelElementDelta delta = null;
                try {
                    ISourceModule sourceModule;
                    if (!(changed != null && changed.size() != 0 || added != null && added.size() != 0 || addedDirectories != null && addedDirectories.size() != 0)) {
                        return;
                    }
                    delta = new ModelElementDelta((IModelElement)ModelManager.getInstance().getModel());
                    for (IDirectory dir : addedDirectories) {
                        ISourceFolder fld = ModelUtils.convertFolder(dir);
                        if (fld == null) continue;
                        delta.added(fld);
                    }
                    for (IModule module : added) {
                        sourceModule = ModelUtils.convertModule(module);
                        if (sourceModule == null) continue;
                        delta.added((IModelElement)sourceModule);
                    }
                    for (IModule changedModule : changed) {
                        ModelElementDelta moduleDelta;
                        ModelElementDeltaBuilder builder;
                        sourceModule = ModelUtils.convertModule(changedModule);
                        if (sourceModule == null || (builder = this.deltaBuilders.get(sourceModule)) == null || (moduleDelta = builder.buildDeltas()) == null) continue;
                        delta.insertDeltaTree((IModelElement)sourceModule, moduleDelta);
                    }
                }
                finally {
                    this.deltaBuilders.clear();
                }
                if (delta != null) {
                    ModelManager.this.notifyDelta(delta);
                }
            }

            @Override
            public void beforeIndexChange(List<IModule> changed, List<IModule> removed, List<IDirectory> removedDirectories) {
                ISourceModule sourceModule;
                if (!(changed != null && changed.size() != 0 || removed != null && removed.size() != 0 || removedDirectories != null && removedDirectories.size() != 0)) {
                    return;
                }
                ModelElementDelta delta = new ModelElementDelta((IModelElement)ModelManager.getInstance().getModel());
                for (IDirectory dir : removedDirectories) {
                    ISourceFolder fld = ModelUtils.convertFolder(dir);
                    if (fld == null) continue;
                    delta.removed(fld);
                }
                for (IModule module : removed) {
                    sourceModule = ModelUtils.convertModule(module);
                    if (sourceModule == null) continue;
                    delta.removed((IModelElement)sourceModule);
                }
                for (IModule changedModule : changed) {
                    sourceModule = ModelUtils.convertModule(changedModule);
                    if (sourceModule == null) continue;
                    ModelElementDeltaBuilder builder = new ModelElementDeltaBuilder((IModelElement)sourceModule);
                    this.deltaBuilders.put(sourceModule, builder);
                }
                if (removed != null && removed.size() != 0 || removedDirectories != null && removedDirectories.size() != 0) {
                    ModelManager.this.notifyDelta(delta);
                }
            }
        };
        PHPGlobalIndexer.getInstance().addListener(this.moduleIndexListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDelta(IModelElementDelta delta) {
        HashSet<IModelDeltaListener> toNotify = null;
        Set<IModelDeltaListener> set = this.listeners;
        synchronized (set) {
            toNotify = new HashSet<IModelDeltaListener>(this.listeners.size());
            toNotify.addAll(this.listeners);
        }
        for (IModelDeltaListener listener : toNotify) {
            listener.notify(delta);
        }
    }
}

